<?php
/**
* @version $Id: mod_rd_section_blog.php,v 1.2 2005/07/05 09:32:08 deutz Exp $
* @package RD_Section_Blog
* @copyright Copyright (C) 2005 run-digital
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* 
* This is free software
*/

/** ensure this file is being included by a parent file **/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_offset, $mosConfig_live_site, $mainframe;

# --------- Get the parameters

$count = intval( $params->get( 'count', 5 ) ); # How many content elements at all?
$leadstoryCount = intval( $params->get( 'leadstory', 1 ) ); # How many as lead stories?

$catid = trim( $params->get( 'catid' ) ); # Which Category/Categories?
$secid = trim( $params->get( 'secid' ) ); # Which Section/Sections?
$show_front = intval($params->get( 'show_front', 1 ) ); # Show Frontpage elements as well?

$show_section_title = intval($params->get( 'show_section_title', 0 ) ); # Show Section Titles?
$show_section_nameortitle = intval($params->get( 'show_section_nameortitle', 0 ) ); # Show Section Names or Titles?

$show_category_title = intval($params->get( 'show_category_title', 1 ) ); # Show Category Titles?
$show_category_nameortitle = intval($params->get( 'show_category_nameortitle', 0 ) ); # Show Category Names or Titles?

$sect_cat_sep = trim( $params->get( 'sect_cat_sep', "::" ) ); # Infix between Section and Category name (if displayed both)

$header_level = intval($params->get( 'header_level', 1 ) ); # Which <h>?
$content_level = $header_level + 1;

$header_class = trim( $params->get( 'header_class', "" ) ); # Additional class for <h>'s and <ul>
$header_class = ( $header_class ? " class=\"$header_class\"" : "");

$show_create=intval($params->get( 'show_create', 0 ) ); # Show create dates?
if ($show_create=="2") { $show_create=!$mainframe->getCfg( 'hideCreateDate' ); }

$show_mod=intval($params->get( 'show_mod', 0 ) ); # Show Last Modified  dates?
if ($show_mod=="2") { $show_mod=!$mainframe->getCfg( 'hideModifyDate' ); }

$show_auth=intval($params->get( 'show_auth', 0 ) ); # Show Author name?
if ($show_auth=="2") { $show_auth=!$mainframe->getCfg( 'hideAuthor' ); }

$bots = intval($params->get( 'bots', 1 ) ); # Let Mambots/Plugins work on the content element?

# --------- Get the parameters (END)

if ( $secid ) { # Section given at all?

	$rows = array();

	if (substr_count($secid,",") != 0) { # More than one Section given?
		$seca = explode (",", $secid);
	} else {
		$seca = array($secid);
	}
	$now 		= _CURRENT_SERVER_TIME; # date( 'Y-m-d H:i:s', time()+$mosConfig_offset*60*60 );

	# --- Retrieve section names -- compatible with Joom!Fish
	$secids=implode(",",$seca);
	$infotag=($show_section_nameortitle=="1" ? "name" : "title");
	$query= "SELECT id,$infotag FROM #__sections".
					" WHERE id IN ($secids) AND published = '1'";

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	$secnames=array();
	if ($rows) foreach ($rows as $row) { $secnames[$row->id] = $row->$infotag; }
	# echo "<pre>"; print_r($secnames); echo "</pre>\n"; # DEBUG
	# --- End Retrieve section title


	foreach ($seca as $sec) { # Work through all Sections

		# Get categories

		if ( $catid ) { # Catogory given?

			if (substr_count($catid,",") != 0) { # More than one Category given?
				$cata = explode (",", $catid);
			} else {
				$cata = array($catid);
			}

		} else { # if ( $catid )

			$query= "SELECT id FROM #__categories"
			. "\n WHERE section = '".$sec."' AND published = '1'"
			. "\n ORDER BY ordering";
			$database->setQuery( $query );
			$cata = $database->loadResultArray();

		} # else if ( $catid )

		# --- Retrieve category names -- compatible with Joom!Fish
		$catids=implode(",",$cata);
		$infotag=($show_category_nameortitle=="1" ? "name" : "title");
		$query= "SELECT id,$infotag FROM #__categories".
						" WHERE id IN ($catids) AND published = '1'";

		$database->setQuery( $query );
		$rows = $database->loadObjectList();

		$catnames=array();
		if ($rows) foreach ($rows as $row) { $catnames[$row->id] = $row->$infotag; }
		# echo "<pre>"; print_r($catnames); echo "</pre>\n"; # DEBUG
		# --- End Retrieve category names

		foreach ($cata as $cat) { # work through all Categories

			$limcount=( $count>0 ? "LIMIT $count" : "");

			# Get the content elements from this Category
			$query = "SELECT a.id, a.title, s.id AS section, c.id AS category, a.introtext as text,"
							. "\n a.fulltext, a.attribs, a.images, a.created, a.modified, a.created_by, a.created_by_alias"
							. "\n FROM #__sections AS s, #__categories AS c, #__content AS a"
							. "\n LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id"
							. "\n WHERE a.sectionid = s.id AND a.catid = c.id"
							. "\n AND ( a.state = '1' AND a.checked_out = '0' AND a.sectionid > '0' )"
							. "\n AND ( a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '". $now ."' )"
							. "\n AND ( a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '". $now ."' )"
							. "\n AND a.catid = ". $cat
							. "\n AND a.sectionid = ". $sec
							. ( $show_front == "0" ? "\n AND f.content_id IS NULL" : '' )
							. "\n ORDER BY a.ordering $limcount"
							;

			$database->setQuery( $query );
			$rows = $database->loadObjectList();
			$numRows=count($rows);

			$acount = $numRows; # Default: all

			if ( ($count>0) and ($numRows>$count) ) { # Limit set? Then use it
				$acount = $count;
			}

			reset ($rows);
			list(,$r) = each($rows);

			$sectiontext = $secnames[$r->section]; # Section name from array
			$categorytext = $catnames[$r->category]; # Categofy name from array
			reset ($rows);

			if ($acount) {

				# Output
				echo '<div><h'.$header_level.$header_class.'>';

				if ($show_section_title) {
					echo $sectiontext;
					if ($show_category_title) { echo " ".$sect_cat_sep." ".$categorytext;}
				} else {
					if ($show_category_title) { echo $categorytext;}
				}

				echo '</h'.$header_level.'>';

				$ul='';

				if ($leadstoryCount>0) { # No "More ..." if there is no message shown in long format
					$ul='<div><br /></div><div class="blog_more"><strong>'._MORE.'</strong></div>'; # "More ..." text element
				}

				$ul.='<ul'.$header_class.'>'; # Here starts the unsorted list with short element displays
				$nals ='';

				for ($i=1; $i <= $acount; $i++) {

					list(,$r) = each($rows);

					# get itemid if contentitem in menu
					$contentid = $r->id; # BUG FIXED: "$row->id" => "$r->id"
					$query = "select id from #__menu where published = '1' and type = 'content_item_link' and componentid='$contentid';";
					$database->setQuery( $query );
					$Itemid = $database->loadresult();

					if (!$Itemid) {
						# needed to reduce queries used by getItemid 
						$bs = $mainframe->getBlogSectionCount();
						$bc = $mainframe->getBlogCategoryCount();
						$gbs = $mainframe->getGlobalBlogSectionCount();
						# get Itemid # BUG FIXED: "$row->id" => "$r->id"
						$Itemid = $mainframe->getItemid( $r->id, 0, 0, $bs, $bc, $gbs );
					} 

					# Blank itemid checker for SEF
					if ($Itemid == NULL) {
						$Itemid = '';
					} else {
						$Itemid = '&amp;Itemid='. $Itemid;
					}

					# No leadstoryCount limit set? Then show all complete
					$belowleadlimit=($leadstoryCount < 0 ? true : ($i <= $leadstoryCount) );

					if ($belowleadlimit) {

						$aparams = new mosParameters($r->attribs);
						$compact = intval($aparams->get('compactartikel',0) );

						if ($compact) {

							# not a leadstory 
							$nals = $nals.$ul.'<li><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $r->id . $Itemid ) .'">'. $r->title .'</a><span style="display:none;">.</span></li>'; 
							$ul='';

						} else { # if ($compact)

							# Leadstory 
							echo '<h'.$content_level.$header_class.'><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $r->id . $Itemid ) .'" class="contentpagetitle">'. $r->title .'</a></h'.$content_level.'>';

							echo '<div'.$header_class.'>';
							# echo $r->textt;

							if ($bots=="0") { # Don't use mambots?

								# Strip Mambot pseudocode
								$r->text = preg_replace('/{([a-zA-Z0-9\-_]*)\s*(.*?)}/i', '', $r->text);

							} else { # Use mambots?

								# Code taken from mod_d4j_content_listing by DesignForJoomla.com
								$content_params =& new mosParameters( $r->params );

								# GC Parameters
								$content_params->def( 'link_titles', $mainframe->getCfg( 'link_titles' ) );
								$content_params->def( 'author', !$mainframe->getCfg( 'hideAuthor' ) );
								$content_params->def( 'createdate', !$mainframe->getCfg( 'hideCreateDate' ) );
								$content_params->def( 'modifydate', !$mainframe->getCfg( 'hideModifyDate' ) );
								$content_params->def( 'print', !$mainframe->getCfg( 'hidePrint' ) );
								$content_params->def( 'pdf', !$mainframe->getCfg( 'hidePdf' ) );
								$content_params->def( 'email', !$mainframe->getCfg( 'hideEmail' ) );
								$content_params->def( 'rating', $mainframe->getCfg( 'vote' ) );
								$content_params->def( 'icons', $mainframe->getCfg( 'icons' ) );
								$content_params->def( 'readmore', $mainframe->getCfg( 'readmore' ) );
								# Other Params
								$content_params->def( 'image', 1 );
								$content_params->def( 'section', 0 );
								$content_params->def( 'section_link', 0 );
								$content_params->def( 'category', 0 );
								$content_params->def( 'category_link', 0 );
								$content_params->def( 'introtext', 1 );
								$content_params->def( 'pageclass_sfx', '' );
								$content_params->def( 'item_title', 1 );
								$content_params->def( 'url', 1 );

								# process bots
								global $_MAMBOTS;
								$_MAMBOTS->loadBotGroup( 'content' );
								$_MAMBOTS->trigger( 'onPrepareContent', array( &$r, &$content_params, 0 ), true );

							}

							if ($show_auth) { # Show Author's name?

								$thisauth=$r->created_by_alias; # Let's assume there's an alias

								if (!$thisauth) { # No alias given?
									if ($r->created_by) { # Auther's user ID given?
										$query= "SELECT name FROM #__users WHERE id='".$r->created_by."'";
										$database->setQuery( $query );

										if ($authresult = $database->loadResultArray()) { # Got a result?
											$thisauth=$authresult[0];
										}
									}
								}

								if ($thisauth) { # Got a name?
									echo '<p class="small">'._WRITTEN_BY . ' '.$thisauth.'</p>';
								}
							}

							if ( ( intval( $r->created ) != 0) and ($show_create) ) { # Show Create date?
								$create_date = mosFormatDate( $r->created );
								echo '<p class="createdate">'.$create_date.'</p>';
							}

							echo '<table width="100%" cellspacing="0" cellpadding="0"><tr><td>'.$r->text.'</td></tr></table>';

							if ($r->fulltext) { # Full text existent? Show "Read more"
								echo '<p><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $r->id . $Itemid ) .'" title="'.$r->title.'" class="readon">'._READ_MORE.'</a></p>';
							}


							if ( ( intval( $r->modified ) != 0) and ($show_mod) ) { # Show Last Modified date?
								$mod_date = mosFormatDate( $r->modified );
								echo '<p class="modifydate">'._LAST_UPDATED.' ( '.$mod_date.' )</p>';
							}

							echo '</div>';

						} # else if ($compact)

					} else { # if ($i <= $leadstoryCount)

						# normal Link
						echo $nals;
						$nals ='';
						echo $ul;
						$ul='';
						echo '<li><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $r->id . $Itemid ) .'">'. $r->title .'</a><span style="display:none;">.</span></li>';

					} # else if ($i <= $leadstoryCount)

					if ($nals) {
						echo $nals;
						$nals ='';
					}

				} # for ($i=1; $i <= $acount; $i++)

				if (!$ul) {echo '</ul>';}
			echo '</div>';

			} # if ($acount)
		} # foreach ($cata as $cat)
	} # foreach ($seca as $sec)
} # if ( $secid ) 
/** EOF **/
?>
